// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Insyslogmessage.pas' rev: 10.00

#ifndef InsyslogmessageHPP
#define InsyslogmessageHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Inglobal.hpp>	// Pascal unit
#include <Inglobalprotocols.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Inbasecomponent.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Insyslogmessage
{
//-- type declarations -------------------------------------------------------
typedef Byte TInSysLogPRI;

#pragma option push -b-
enum TInSysLogFacility { sfKernel, sfUserLevel, sfMailSystem, sfSystemDaemon, sfSecurityOne, sfSysLogInternal, sfLPR, sfNNTP, sfClockDaemonOne, sfUUCP, sfSecurityTwo, sfFTPDaemon, sfNTP, sfLogAudit, sfLogAlert, sfClockDaemonTwo, sfLocalUseZero, sfLocalUseOne, sfLocalUseTwo, sfLocalUseThree, sfLocalUseFour, sfLocalUseFive, sfLocalUseSix, sfLocalUseSeven };
#pragma option pop

#pragma option push -b-
enum TInSysLogSeverity { slEmergency, slAlert, slCritical, slError, slWarning, slNotice, slInformational, slDebug };
#pragma option pop

class DELPHICLASS TInSysLogMsgPart;
class PASCALIMPLEMENTATION TInSysLogMsgPart : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
protected:
	bool FPIDAvailable;
	AnsiString FText;
	bool FMsgPIDAvailable;
	void __fastcall SetPIDAvailable(const bool AValue);
	AnsiString __fastcall GetContent();
	AnsiString __fastcall GetProcess();
	void __fastcall SetContent(const AnsiString AValue);
	void __fastcall SetProcess(const AnsiString AValue);
	void __fastcall SetText(const AnsiString AValue);
	int __fastcall GetPID(void);
	void __fastcall SetPID(const int AValue);
	int __fastcall GetMaxTagLength(void);
	virtual AnsiString __fastcall PIDToStr(int APID);
	
public:
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	
__published:
	__property AnsiString Text = {read=FText, write=SetText};
	__property bool PIDAvailable = {read=FPIDAvailable, write=SetPIDAvailable, stored=false, nodefault};
	__property AnsiString Process = {read=GetProcess, write=SetProcess, stored=false};
	__property int PID = {read=GetPID, write=SetPID, stored=false, nodefault};
	__property AnsiString Content = {read=GetContent, write=SetContent, stored=false};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TInSysLogMsgPart(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TInSysLogMsgPart(void) : Classes::TPersistent() { }
	#pragma option pop
	
};


class DELPHICLASS TInSysLogMessage;
class PASCALIMPLEMENTATION TInSysLogMessage : public Inbasecomponent::TInBaseComponent 
{
	typedef Inbasecomponent::TInBaseComponent inherited;
	
protected:
	TInSysLogMsgPart* FMsg;
	TInSysLogFacility FFacility;
	TInSysLogSeverity FSeverity;
	AnsiString FHostname;
	AnsiString FMessage;
	System::TDateTime FTimeStamp;
	AnsiString FRawMessage;
	AnsiString FPeer;
	TInSysLogPRI FPri;
	Inbasecomponent::TInBaseComponent* FUDPCliComp;
	void __fastcall SetFacility(const TInSysLogFacility AValue);
	void __fastcall SetSeverity(const TInSysLogSeverity AValue);
	void __fastcall SetHostname(const AnsiString AValue);
	void __fastcall SetRawMessage(const AnsiString Value);
	void __fastcall SetTimeStamp(const System::TDateTime AValue);
	void __fastcall SetMsg(const TInSysLogMsgPart* AValue);
	void __fastcall SetPri(const TInSysLogPRI Value);
	AnsiString __fastcall GetHeader();
	virtual void __fastcall CheckASCIIRange(AnsiString &Data);
	virtual void __fastcall ReadPRI(int &StartPos);
	virtual void __fastcall ReadHeader(int &StartPos);
	virtual void __fastcall ReadMSG(int &StartPos);
	virtual void __fastcall parse(void);
	virtual void __fastcall UpdatePRI(void);
	virtual System::TDateTime __fastcall DecodeTimeStamp(AnsiString TimeStampString);
	virtual void __fastcall InitComponent(void);
	
public:
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__fastcall virtual ~TInSysLogMessage(void);
	virtual AnsiString __fastcall EncodeMessage();
	virtual void __fastcall ReadFromBytes(const Inglobal::TBytes ASrc, const AnsiString APeer);
	__property AnsiString RawMessage = {read=FRawMessage, write=SetRawMessage};
	void __fastcall SendToHost(const AnsiString Dest);
	__property AnsiString Peer = {read=FPeer, write=FPeer};
	__property System::TDateTime TimeStamp = {read=FTimeStamp, write=SetTimeStamp};
	
__published:
	__property TInSysLogPRI Pri = {read=FPri, write=SetPri, default=13};
	__property TInSysLogFacility Facility = {read=FFacility, write=SetFacility, stored=false, nodefault};
	__property TInSysLogSeverity Severity = {read=FSeverity, write=SetSeverity, stored=false, nodefault};
	__property AnsiString Hostname = {read=FHostname, write=SetHostname, stored=false};
	__property TInSysLogMsgPart* Msg = {read=FMsg, write=SetMsg};
public:
	#pragma option push -w-inl
	/* TInBaseComponent.Create */ inline __fastcall TInSysLogMessage(Classes::TComponent* AOwner)/* overload */ : Inbasecomponent::TInBaseComponent(AOwner) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE Word __fastcall logFacilityToNo(TInSysLogFacility AFac);
extern PACKAGE TInSysLogFacility __fastcall NoToFacility(Word AFac);
extern PACKAGE Word __fastcall logSeverityToNo(TInSysLogSeverity ASev);
extern PACKAGE TInSysLogSeverity __fastcall NoToSeverity(Word ASev);
extern PACKAGE AnsiString __fastcall SeverityToString(TInSysLogSeverity ASec);
extern PACKAGE AnsiString __fastcall FacilityToString(TInSysLogFacility AFac);

}	/* namespace Insyslogmessage */
using namespace Insyslogmessage;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Insyslogmessage
